/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os;

import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.appwork.utils.os.CrossSystem;

public class CrossSystem17 {
    public static boolean caseSensitiveFileExists(File file) throws IOException {
        try {
            Path root;
            Path filePath = file.toPath().toRealPath(LinkOption.NOFOLLOW_LINKS);
            String filePathString = filePath.toString();
            String fileString = file.getAbsolutePath();
            if (filePathString.equals(fileString)) {
                return true;
            }
            if (CrossSystem.isWindows() && (root = filePath.getRoot()) != null) {
                String rootString = root.toString();
                String fileString2 = fileString.replaceFirst("(?i)^" + Pattern.quote(rootString), Matcher.quoteReplacement(rootString));
                return filePathString.equals(fileString2);
            }
            return false;
        }
        catch (NoSuchFileException e) {
            return false;
        }
    }
}

