/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.parser;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.appwork.utils.IO;

public class SourceParser {
    private static final Pattern PATTERN_REMOVE_COMENTS1 = Pattern.compile("\\/\\*.*?\\*\\/", 32);
    private static final Pattern PATTERN_REMOVE_COMENTS2 = Pattern.compile("//.*");
    private HashMap<File, String[]> map = new HashMap();
    private final File sourceFolder;
    private FilenameFilter filter;

    public SourceParser(File file) throws IOException {
        this.sourceFolder = file;
        this.filter = null;
    }

    public HashMap<File, String> findOccurancesOf(Field f) {
        HashMap<File, String> found = new HashMap<File, String>();
        for (Map.Entry<File, String[]> next : this.map.entrySet()) {
            for (String statement : next.getValue()) {
                if (!statement.contains(f.getName())) continue;
                if (statement.contains("//") || statement.contains("/*")) {
                    // empty if block
                }
                found.put(next.getKey(), statement);
            }
        }
        return found;
    }

    public File getSource() {
        return this.sourceFolder;
    }

    private void getSourceFiles(File file) throws IOException {
        for (File f : file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !(SourceParser.this.filter != null && !SourceParser.this.filter.accept(dir, name) || !name.endsWith(".java") && !new File(dir, name).isDirectory());
            }
        })) {
            if (f.isDirectory()) {
                this.getSourceFiles(f);
                continue;
            }
            String statement = IO.readFileToString(f);
            statement = PATTERN_REMOVE_COMENTS1.matcher(statement).replaceAll("/*comment*/");
            statement = PATTERN_REMOVE_COMENTS2.matcher(statement).replaceAll("//comment");
            this.map.put(f, statement.split("[\\{\\}\\;]"));
        }
    }

    public void scan() throws IOException {
        this.map = new HashMap();
        this.getSourceFiles(this.sourceFolder);
    }

    public void setFilter(FilenameFilter filenameFilter) {
        this.filter = filenameFilter;
    }
}

