/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.swing.components.tooltips.ToolTipHandler;
import org.appwork.swing.components.tooltips.TooltipTextDelegateFactory;
import org.appwork.utils.NullsafeAtomicReference;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.graph.Limiter;

public abstract class Graph
extends JPanel
implements ToolTipHandler {
    private static final long serialVersionUID = 6943108941655020136L;
    private volatile int valueIndex;
    private transient NullsafeAtomicReference<Thread> fetcherThread = new NullsafeAtomicReference<Object>(null);
    private int interval = 1000;
    private final Object LOCK = new Object();
    private Color currentColorTop;
    private Color currentColorBottom;
    protected volatile long average;
    protected volatile long all;
    protected volatile int value;
    protected long[] averageCache;
    protected long[] cache;
    private Color averageColor = new Color(0x333333);
    private Color averageTextColor = new Color(0);
    private int capacity = 0;
    private Color textColor = new Color(0);
    private Font textFont;
    private Limiter[] limiter;
    private TooltipTextDelegateFactory tooltipFactory = new TooltipTextDelegateFactory(this);
    private boolean antiAliasing = false;

    public Graph() {
        this(60, 1000);
    }

    public Graph(int capacity, int interval) {
        this.setCurrentColorTop(new Color(100, 100, 100, 40));
        this.setCurrentColorBottom(new Color(100, 100, 100, 80));
        this.average = 0L;
        this.setInterval(interval);
        this.setCapacity(capacity);
        this.setOpaque(false);
        this.setTextFont(new JLabel().getFont());
    }

    @Override
    public ExtTooltip createExtTooltip(Point mousePosition) {
        return this.getTooltipFactory().createTooltip();
    }

    protected String createTooltipText() {
        return this.getAverageSpeedString() + "  " + this.getSpeedString();
    }

    public Color getAverageColor() {
        return this.averageColor;
    }

    public long getAverageSpeed() {
        long all = this.all;
        if (all == 0L) {
            return 0L;
        }
        return this.average / all;
    }

    public String getAverageSpeedString() {
        long all = this.all;
        if (all <= 0L) {
            return null;
        }
        return _AWU.T.AppWorkUtils_Graph_getAverageSpeedString2(SizeFormatter.formatBytes(this.average / all));
    }

    public Color getAverageTextColor() {
        return this.averageTextColor;
    }

    public Color getCurrentColorBottom() {
        return this.currentColorBottom;
    }

    public Color getCurrentColorTop() {
        return this.currentColorTop;
    }

    public int getInterval() {
        return this.interval;
    }

    public Limiter[] getLimiter() {
        return this.limiter;
    }

    protected int getPaintHeight() {
        return this.getHeight();
    }

    public String getSpeedString() {
        if (this.all <= 0L) {
            return null;
        }
        return _AWU.T.AppWorkUtils_Graph_getSpeedString(SizeFormatter.formatBytes(this.value));
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    @Override
    public int getTooltipDelay(Point mousePositionOnScreen) {
        return 0;
    }

    public TooltipTextDelegateFactory getTooltipFactory() {
        return this.tooltipFactory;
    }

    public abstract int getValue();

    public boolean isAntiAliasing() {
        return this.antiAliasing;
    }

    @Override
    public boolean isTooltipDisabledUntilNextRefocus() {
        return false;
    }

    @Override
    public boolean isTooltipWithoutFocusEnabled() {
        return true;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintComponent(g, true);
    }

    public void paintComponent(Graphics g, boolean paintText) {
        Thread thread = this.fetcherThread.get();
        if (thread != null) {
            int fontHeight;
            Graphics2D g2 = (Graphics2D)g;
            if (!this.antiAliasing) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            g2.setStroke(new BasicStroke(1.0f));
            int id = this.valueIndex;
            long max = 10L;
            for (long element : this.cache) {
                max = Math.max(element, max);
            }
            for (long element : this.averageCache) {
                max = Math.max(element, max);
            }
            Limiter[] limitertmp = this.getLimiter();
            if (limitertmp != null) {
                for (Limiter l : limitertmp) {
                    max = Math.max((long)l.getValue(), max);
                }
            }
            int polyHeight = this.getPaintHeight();
            Polygon poly = new Polygon();
            poly.addPoint(0, this.getHeight());
            Polygon apoly = new Polygon();
            apoly.addPoint(0, this.getHeight());
            long[] lCache = this.cache;
            long[] laverageCache = this.averageCache;
            for (int x = 0; x < lCache.length; ++x) {
                int polyX = x * this.getWidth() / (lCache.length - 1);
                poly.addPoint(polyX, this.getHeight() - (int)((double)((long)polyHeight * lCache[id]) * 0.9 / (double)max));
                if (this.averageColor != null) {
                    apoly.addPoint(polyX, this.getHeight() - (int)((double)((long)polyHeight * laverageCache[id]) * 0.9 / (double)max));
                }
                ++id;
                id %= lCache.length;
            }
            poly.addPoint(this.getWidth(), this.getHeight());
            if (this.averageColor != null) {
                apoly.addPoint(this.getWidth(), this.getHeight());
            }
            g2.setPaint(new GradientPaint(this.getWidth() / 2, this.getHeight() - this.getPaintHeight(), this.currentColorTop, this.getWidth() / 2, this.getHeight(), this.currentColorBottom));
            g2.fill(poly);
            g2.setColor(this.currentColorBottom);
            g2.draw(poly);
            if (this.averageColor != null) {
                ((Graphics2D)g).setColor(this.averageColor);
                AlphaComposite ac5 = AlphaComposite.getInstance(3, 0.5f);
                g2.setComposite(ac5);
                g2.fill(apoly);
                g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
                g2.draw(apoly);
            }
            if (this.textFont != null) {
                g2.setFont(this.textFont);
            }
            int textHeight = fontHeight = g2.getFontMetrics().getHeight();
            if (limitertmp != null) {
                for (Limiter l : limitertmp) {
                    if (l.getValue() <= 0) continue;
                    int h = this.getHeight() - (int)((double)(polyHeight * l.getValue()) * 0.9 / (double)max);
                    h = Math.min(this.getHeight() - 2, h);
                    g2.setPaint(new GradientPaint(this.getWidth() / 2, h, l.getColorA(), this.getWidth() / 2, h + polyHeight / 10, l.getColorB()));
                    g2.fillRect(0, h, this.getWidth(), polyHeight / 10);
                    String str = l.getString();
                    if (!StringUtils.isNotEmpty(str)) continue;
                    int xText = this.getWidth() - 3 - g2.getFontMetrics().stringWidth(str);
                    g2.setColor(l.getColorA());
                    if (this.getHeight() - h < fontHeight - 3) {
                        g2.drawString(str, xText, h - fontHeight + 5);
                        textHeight = h - 1;
                        continue;
                    }
                    if (h > fontHeight - 6) {
                        g2.drawString(str, xText, h - 1);
                        textHeight = h + fontHeight - 4;
                        continue;
                    }
                    g2.drawString(str, xText, h + fontHeight + 5);
                    textHeight = h + fontHeight - 4;
                }
            }
            if (paintText) {
                String speedString;
                int xText = this.getWidth();
                if (this.textFont != null) {
                    g2.setFont(this.textFont);
                }
                if ((speedString = this.getSpeedString()) != null && thread != null) {
                    g2.setColor(this.getTextColor());
                    xText = xText - 3 - g2.getFontMetrics().stringWidth(speedString);
                    g2.drawString(speedString, xText, textHeight);
                }
                if (this.getAverageTextColor() != null && (speedString = this.getAverageSpeedString()) != null && thread != null) {
                    g2.setColor(this.getAverageTextColor());
                    g2.drawString(speedString, 0, textHeight);
                }
            }
        }
    }

    protected void resetAverage() {
        long tmp = this.all;
        this.average = tmp == 0L ? 0L : (this.average /= tmp);
        this.average *= 3L;
        this.all = 3L;
    }

    public void setAntiAliasing(boolean antiAliasing) {
        this.antiAliasing = antiAliasing;
    }

    public void setAverageColor(Color averageColor) {
        this.averageColor = averageColor;
        if (averageColor == null || averageColor.getAlpha() == 0) {
            this.averageColor = null;
        }
    }

    public void setAverageTextColor(Color averageTextColor) {
        this.averageTextColor = averageTextColor;
        if (averageTextColor == null || averageTextColor.getAlpha() == 0) {
            this.averageTextColor = null;
        }
    }

    protected void setCapacity(int cap) {
        if (this.fetcherThread.get() != null) {
            throw new IllegalStateException("Already started");
        }
        this.capacity = cap;
        this.averageCache = new long[cap];
        this.cache = new long[cap];
    }

    public void setCurrentColorBottom(Color colorB) {
        this.currentColorBottom = colorB != null ? colorB : new Color(100, 100, 100, 80);
    }

    public void setCurrentColorTop(Color colorA) {
        this.currentColorTop = colorA != null ? colorA : new Color(100, 100, 100, 40);
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setLimiter(Limiter[] limiter) {
        this.limiter = limiter;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public void setTextFont(Font textFont) {
        this.textFont = textFont;
    }

    public void setTooltipFactory(TooltipTextDelegateFactory tooltipFactory) {
        this.tooltipFactory = tooltipFactory;
    }

    @Override
    public void setToolTipText(String text) {
        this.putClientProperty("ToolTipText", text);
        if (text == null || text.length() == 0) {
            ToolTipController.getInstance().unregister(this);
        } else {
            ToolTipController.getInstance().register(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.LOCK;
        synchronized (object) {
            Thread thread = this.fetcherThread.get();
            if (thread != null && thread.isAlive()) {
                return;
            }
            this.valueIndex = 0;
            thread = new Thread("Speedmeter updater"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Override
                public void run() {
                    painter = null;
                    try {
                        painter = new Timer(Graph.this.getInterval(), new ActionListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Object object = Graph.this.LOCK;
                                synchronized (object) {
                                    Graph.this.setToolTipText(Graph.this.createTooltipText());
                                    Graph.this.repaint();
                                }
                            }
                        });
                        painter.setRepeats(true);
                        painter.setInitialDelay(0);
                        painter.start();
                        Graph.this.all = 0L;
                        Graph.this.average = 0L;
                        while (true) lbl-1000:
                        // 2 sources

                        {
                            var2_2 = Graph.access$000(Graph.this);
                            synchronized (var2_2) {
                                Graph.this.value = Graph.this.getValue();
                                Graph.this.average = Graph.this.all == (long)Graph.this.cache.length ? Graph.this.average - Graph.this.cache[Graph.access$100(Graph.this)] + (long)Graph.this.value : (Graph.this.average += (long)Graph.this.value);
                                Graph.this.all = Math.min(Graph.this.all + 1L, (long)Graph.this.cache.length);
                                Graph.this.averageCache[Graph.access$100((Graph)Graph.this)] = Graph.this.average / Graph.this.all;
                                Graph.this.cache[Graph.access$100((Graph)Graph.this)] = Graph.this.value;
                                Graph.access$108(Graph.this);
                                Graph.access$102(Graph.this, Graph.access$100(Graph.this) % Graph.this.cache.length);
                            }
                            if (this.isInterrupted() || Thread.currentThread() != Graph.access$200(Graph.this).get()) ** GOTO lbl47
                            try {
                                Thread.sleep(Graph.this.getInterval());
                                continue;
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            break;
                        }
                    }
                    catch (Throwable var5_6) {
                        var6_7 = Graph.access$000(Graph.this);
                        synchronized (var6_7) {
                            Graph.access$200(Graph.this).compareAndSet(Thread.currentThread(), null);
                            if (painter != null) {
                                painter.stop();
                            }
                        }
                        new EDTRunner(){

                            @Override
                            protected void runInEDT() {
                                Graph.this.repaint();
                            }
                        };
                        throw var5_6;
                    }
                    {
                        ** while (true)
                    }
lbl47:
                    // 2 sources

                    var2_2 = Graph.access$000(Graph.this);
                    synchronized (var2_2) {
                        Graph.access$200(Graph.this).compareAndSet(Thread.currentThread(), null);
                        if (painter != null) {
                            painter.stop();
                        }
                    }
                    new /* invalid duplicate definition of identical inner class */;
                }
            };
            thread.setDaemon(true);
            this.fetcherThread.set(thread);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.LOCK;
        synchronized (object) {
            Thread oldThread = this.fetcherThread.getAndSet(null);
            if (oldThread != null) {
                oldThread.interrupt();
            }
            this.repaint();
            this.setCapacity(this.capacity);
        }
    }

    @Override
    public boolean updateTooltip(ExtTooltip activeToolTip, MouseEvent e) {
        return false;
    }

    static /* synthetic */ int access$100(Graph x0) {
        return x0.valueIndex;
    }

    static /* synthetic */ int access$108(Graph x0) {
        return x0.valueIndex++;
    }

    static /* synthetic */ int access$102(Graph x0, int x1) {
        x0.valueIndex = x1;
        return x0.valueIndex;
    }

    static /* synthetic */ NullsafeAtomicReference access$200(Graph x0) {
        return x0.fetcherThread;
    }
}

