/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dimensor;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.dimensor.DimensorInterface;

public abstract class AbstractDimensor
implements DimensorInterface {
    protected String id;

    public AbstractDimensor(String id) {
        this.id = id;
    }

    protected Dimension validate(Dimension dimension, Window window) {
        Dimension minimum;
        if (dimension != null && window != null && (minimum = window.getMinimumSize()) != null) {
            if (dimension.height <= minimum.height && dimension.width <= minimum.width) {
                return null;
            }
            Dimension ret = new Dimension(Math.max(dimension.width, minimum.width), Math.max(dimension.height, minimum.height));
            return ret;
        }
        return dimension;
    }

    protected String getStorageID(Window window) {
        return this.getClass().getName().replaceAll("(^.*\\.|[\\d\\$]+$)", "") + "-" + this.getID(window);
    }

    protected String getID(Window window) {
        if (this.id == null) {
            String title = "";
            if (window instanceof Dialog) {
                title = ((Dialog)window).getTitle();
            }
            if (StringUtils.isEmpty(title) && window instanceof Frame) {
                title = ((Frame)window).getTitle();
            }
            this.id = window.getClass().getName().replaceAll("[\\d\\$]+$", "") + "-" + title;
        }
        return this.id;
    }
}

