/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.locator;

import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.swing.locationstore.LocationStorage;
import org.appwork.utils.swing.locationstore.LocationStorageManager;
import org.appwork.utils.swing.locator.AbstractLocator;
import org.appwork.utils.swing.locator.CenterOfScreenLocator;

public class RememberAbsoluteLocator
extends AbstractLocator {
    public static final String TYPE = "absolute";

    public RememberAbsoluteLocator(String id) {
        super(id);
    }

    @Override
    public Point getLocationOnScreen(Window window) {
        try {
            LocationStorage cfg = LocationStorageManager.INSTANCE.get(window, this.getStorageID(window));
            if (cfg.isValid() && TYPE.equalsIgnoreCase(cfg.getType())) {
                return AbstractLocator.validate(new Point(cfg.getX(), cfg.getY()), window);
            }
        }
        catch (Throwable e) {
            LogV3.logger(this).exception("Swallowed", e);
        }
        return new CenterOfScreenLocator().getLocationOnScreen(window);
    }

    @Override
    public void onClose(Window window, ComponentEvent event) {
        try {
            if (window.isShowing()) {
                Point locationOnScreen = window.getLocationOnScreen();
                LocationStorage cfg = LocationStorageManager.INSTANCE.get(window, this.getStorageID(window));
                LocationStorageManager.INSTANCE.onUpdate(window, locationOnScreen, null, cfg, TYPE);
            }
        }
        catch (Throwable e) {
            LogV3.logger(this).exception("Swallowed", e);
        }
    }
}

