/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.windowmanager;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.appwork.swing.PropertyStateEventProviderInterface;
import org.appwork.swing.event.PropertySetListener;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.appwork.utils.swing.windowmanager.WindowResetListener;
import org.appwork.utils.swing.windowmanager.WindowsWindowManager;

public class ResetRunnable
implements ActionListener,
PropertySetListener {
    private WindowsWindowManager windowsWindowManager;
    private Window w;
    private WindowManager.FrameState state;
    private boolean oldFocusableWindowState;
    private boolean oldAlwaysOnTop;
    private boolean oldFocusable;

    public WindowManager.FrameState getState() {
        return this.state;
    }

    public ResetRunnable(WindowsWindowManager windowsWindowManager, Window w, WindowResetListener hasListener) {
        this.windowsWindowManager = windowsWindowManager;
        this.w = w;
        if (hasListener != null) {
            hasListener.resetProperties();
        }
        this.oldFocusableWindowState = w.getFocusableWindowState();
        this.oldAlwaysOnTop = w.isAlwaysOnTop();
        this.oldFocusable = w.isFocusable();
        if (w instanceof PropertyStateEventProviderInterface) {
            ((PropertyStateEventProviderInterface)((Object)w)).getPropertySetEventSender().addListener(this, true);
        }
    }

    public Window getWindow() {
        return this.w;
    }

    public void setState(WindowManager.FrameState flags) {
        this.state = flags;
    }

    @Override
    public void onPropertySet(Component caller, String propertyName, Object oldValue, Object newValue) {
        if (propertyName == null || propertyName.equals(this.windowsWindowManager.getBlocker())) {
            return;
        }
        if ("focusableWindowState".equals(propertyName)) {
            this.oldFocusableWindowState = (Boolean)newValue;
        } else if ("focusable".equals(propertyName)) {
            this.oldFocusable = (Boolean)newValue;
        } else if ("alwaysOnTop".equals(propertyName)) {
            this.oldAlwaysOnTop = (Boolean)newValue;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionevent) {
        if (this.w instanceof PropertyStateEventProviderInterface) {
            ((PropertyStateEventProviderInterface)((Object)this.w)).getPropertySetEventSender().removeListener(this);
        }
        this.windowsWindowManager.removeTimer(this);
        this.windowsWindowManager.setAlwaysOnTop(this.w, this.oldAlwaysOnTop);
        switch (this.getState()) {
            case TO_FRONT_FOCUSED: 
            case TO_FRONT: {
                this.windowsWindowManager.setFocusableWindowState(this.w, this.oldFocusableWindowState);
                this.windowsWindowManager.setFocusable(this.w, this.oldFocusable);
                break;
            }
            default: {
                this.windowsWindowManager.setFocusableWindowState(this.w, this.oldFocusableWindowState);
                this.windowsWindowManager.setFocusable(this.w, this.oldFocusable);
            }
        }
    }
}

