/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.LEB128;

public class CompressedEntriesIndex {
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public byte[] compress(List<String> entries) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            this.compress(entries, os);
        }
        catch (IOException e) {
            throw new WTFException(e);
        }
        return os.toByteArray();
    }

    public void compress(List<String> entries, OutputStream os) throws IOException {
        ArrayList<Object[]> wrapped_entries = new ArrayList<Object[]>();
        HashMap<String, Integer> directory_Map = new HashMap<String, Integer>();
        for (String entry : entries) {
            wrapped_entries.add(new Object[]{0, entry});
            if (!entry.endsWith("/")) continue;
            directory_Map.put(entry, wrapped_entries.size());
        }
        this.compactHierarchy(wrapped_entries, directory_Map);
        List<Object[]> wrapped_paths = this.compactPaths(wrapped_entries);
        this.writeTo(os, entries, wrapped_entries, wrapped_paths);
    }

    protected void writeIntOptimized(OutputStream os, int value) throws IOException {
        LEB128.write(os, value);
    }

    protected int readIntOptimized(InputStream is) throws IOException {
        return LEB128.readInt(is, true);
    }

    protected byte[] readFully(InputStream is, int len, byte[] buffer) throws IOException {
        if (buffer == null) {
            buffer = new byte[len];
        }
        new DataInputStream(is).readFully(buffer, 0, len);
        return buffer;
    }

    protected void writeTo(OutputStream os, List<String> entries, List<Object[]> wrapped_entries, List<Object[]> wrapped_paths) throws IOException {
        this.writeIntOptimized(os, entries.size());
        this.writeIntOptimized(os, wrapped_entries.size() - entries.size());
        for (Object[] wrappedEntry : wrapped_entries) {
            Integer entryParentIndex = (Integer)wrappedEntry[0];
            this.writeIntOptimized(os, entryParentIndex);
        }
        for (Object[] wrappedPath : wrapped_paths) {
            Integer pathIndex = (Integer)wrappedPath[0];
            this.writeIntOptimized(os, pathIndex);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (Object[] wrappedPath : wrapped_paths) {
            Integer pathIndex = (Integer)wrappedPath[0];
            if (pathIndex != 0) continue;
            String path = (String)wrappedPath[1];
            byte[] pathBytes = path.getBytes(UTF8);
            this.writeIntOptimized(os, pathBytes.length);
            bos.write(pathBytes);
        }
        bos.writeTo(os);
    }

    protected List<Object[]> compactPaths(List<Object[]> wrapped_paths) {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        HashMap<String, Integer> name_Map = new HashMap<String, Integer>();
        for (int index = 0; index < wrapped_paths.size(); ++index) {
            Object[] pathEntry;
            Object[] wrappedPath = wrapped_paths.get(index);
            String path = (String)wrappedPath[1];
            Integer pathIndex = (Integer)name_Map.get(path);
            if (pathIndex == null) {
                pathEntry = new Object[]{0, path};
                ret.add(pathEntry);
                name_Map.put(path, ret.size());
                continue;
            }
            pathEntry = new Object[]{pathIndex, path};
            ret.add(pathEntry);
        }
        return ret;
    }

    protected void compactHierarchy(List<Object[]> wrapped_entries, Map<String, Integer> directory_Map) {
        int startIndex = 0;
        BitSet skipIndex = new BitSet();
        while (true) {
            for (int index = 0; index < wrapped_entries.size(); ++index) {
                if (skipIndex.get(index)) continue;
                Object[] entry = wrapped_entries.get(index);
                String entryPath = (String)entry[1];
                String[] elements = entryPath.split("/");
                if (elements.length == 1) {
                    skipIndex.set(index);
                    startIndex = skipIndex.nextClearBit(startIndex);
                    continue;
                }
                boolean isDirectory = entryPath.endsWith("/");
                String parentElem = entryPath.replaceFirst(Pattern.quote(elements[elements.length - 1] + (isDirectory ? "/" : "")) + "$", "");
                Integer parentIndex = directory_Map.get(parentElem);
                if (parentIndex == null) {
                    Object[] newEntry = new Object[]{0, parentElem};
                    wrapped_entries.add(newEntry);
                    directory_Map.put(parentElem, wrapped_entries.size());
                    continue;
                }
                String reducedPath = entryPath.replaceFirst("^" + Pattern.quote(parentElem), "");
                entry[0] = parentIndex;
                entry[1] = reducedPath;
            }
            break;
        }
    }

    protected String resolveEntry(List<Object[]> wrapped_entries, int index) {
        Object[] wrappedEntry = wrapped_entries.get(index);
        Integer entryParentIndex = (Integer)wrappedEntry[0];
        String path = (String)wrappedEntry[1];
        if (entryParentIndex == 0) {
            return path;
        }
        String ret = this.resolveEntry(wrapped_entries, entryParentIndex - 1) + path;
        return ret;
    }

    public List<String> uncompress(InputStream is) throws IOException {
        int entries = this.readIntOptimized(is);
        int size = entries + this.readIntOptimized(is);
        ArrayList<Object[]> wrapped_entries = new ArrayList<Object[]>(size);
        for (int index = 0; index < size; ++index) {
            int parentIndex = this.readIntOptimized(is);
            wrapped_entries.add(new Object[]{parentIndex, null});
        }
        ArrayList<Object[]> wrapped_paths = new ArrayList<Object[]>(size);
        for (int index = 0; index < size; ++index) {
            int pathIndex = this.readIntOptimized(is);
            wrapped_paths.add(new Object[]{pathIndex, null});
        }
        for (Object[] wrappedPath : wrapped_paths) {
            if ((Integer)wrappedPath[0] != 0) continue;
            int pathLength = this.readIntOptimized(is);
            wrappedPath[1] = pathLength;
        }
        for (Object[] wrappedPath : wrapped_paths) {
            if (wrappedPath[1] == null) continue;
            byte[] pathBytes = this.readFully(is, (Integer)wrappedPath[1], null);
            String path = new String(pathBytes, UTF8);
            wrappedPath[1] = path;
        }
        for (int index = 0; index < size; ++index) {
            Object[] wrappedEntry = (Object[])wrapped_entries.get(index);
            Object[] wrappedPath = (Object[])wrapped_paths.get(index);
            if ((Integer)wrappedPath[0] != 0) {
                wrappedPath = (Object[])wrapped_paths.get((Integer)wrappedPath[0] - 1);
            }
            wrappedEntry[1] = wrappedPath[1];
        }
        ArrayList<String> ret = new ArrayList<String>(entries);
        for (int index = 0; index < entries; ++index) {
            ret.add(this.resolveEntry(wrapped_entries, index));
        }
        return ret;
    }

    public List<String> uncompress(byte[] data) throws IOException {
        return this.uncompress(new ByteArrayInputStream(data));
    }
}

