/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.updatev2;

import java.awt.Color;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import jd.SecondLevelLaunch;
import jd.controlling.proxy.ProxyController;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.components.IconedProcessIndicator;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.components.circlebar.ImagePainter;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.URLEncode;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.os.hardware.HardwareType;
import org.appwork.utils.os.hardware.HardwareTypeInterface;
import org.appwork.utils.processes.ProcessBuilderFactory;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.appwork.utils.swing.locator.Locator;
import org.appwork.utils.swing.locator.RememberRelativeLocator;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.controller.crawler.CrawlerPluginController;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.updatev2.ConfirmUpdateDialog;
import org.jdownloader.updatev2.InstallLog;
import org.jdownloader.updatev2.ProxyClone;
import org.jdownloader.updatev2.RestartController;
import org.jdownloader.updatev2.UpdateCallbackInterface;
import org.jdownloader.updatev2.UpdateHandler;
import org.jdownloader.updatev2.UpdateProgress;
import org.jdownloader.updatev2.UpdateSettings;
import org.jdownloader.updatev2.UpdateStatusUpdateEvent;
import org.jdownloader.updatev2.UpdaterEvent;
import org.jdownloader.updatev2.UpdaterEventSender;
import org.jdownloader.updatev2._UPDATE;

public class UpdateController
implements UpdateCallbackInterface {
    private volatile Boolean extractionLibrary = null;
    private String extractionError = null;
    private static final UpdateController INSTANCE = new UpdateController();
    private UpdateProgress icon;
    private LogSource logger;
    private UpdateSettings settings;
    private volatile UpdateHandler handler;
    private volatile boolean running;
    private final WeakHashMap<Thread, Object> confirmedThreads = new WeakHashMap();
    private final UpdaterEventSender eventSender = new UpdaterEventSender();
    private Icon statusIcon;
    private String statusLabel;
    private double statusProgress = -1.0;
    private volatile boolean hasPendingUpdates = false;
    private int installedRevisionJDU;
    private int installedRevisionJD;
    public static final int DEBUG_SELFTEST_PORT = System.getProperty("DEBUG_SELFTEST") == null ? -1 : Integer.parseInt(System.getProperty("DEBUG_SELFTEST"));

    public String getExtractionError() {
        return this.extractionError;
    }

    public void setExtractionError(String extractionError) {
        this.extractionError = extractionError;
    }

    public Boolean getExtractionLibrary() {
        return this.extractionLibrary;
    }

    public void setExtractionLibrary(Boolean extractionLibrary) {
        this.extractionLibrary = extractionLibrary;
    }

    public static UpdateController getInstance() {
        return INSTANCE;
    }

    public LogSource getLogger() {
        return this.logger;
    }

    private UpdateController() {
        this.logger = LogController.getInstance().getLogger(UpdateController.class.getName());
        this.settings = JsonConfig.create(UpdateSettings.class);
        this.installedRevisionJDU = this.readRevision("update/versioninfo/JDU/rev");
        this.installedRevisionJD = this.readRevision("update/versioninfo/JD/rev");
    }

    public int getInstalledRevisionJDU() {
        return this.installedRevisionJDU;
    }

    public int getInstalledRevisionJD() {
        return this.installedRevisionJD;
    }

    public UpdateHandler getHandler() {
        return this.handler;
    }

    public void setHandler(UpdateHandler handler, ConfigInterface updaterSetup, String appid, String updaterid) {
        this.handler = handler;
        LogSource newLogger = handler.getLogger();
        if (newLogger != null) {
            if (this.logger != null) {
                this.logger.close();
            }
            this.logger = newLogger;
        }
        this.hasPendingUpdates = handler.hasPendingUpdates();
        handler.startIntervalChecker();
        try {
            SecondLevelLaunch.UPDATE_HANDLER_SET.setReached();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private synchronized boolean isThreadConfirmed() {
        return this.confirmedThreads.containsKey(Thread.currentThread());
    }

    private synchronized void setUpdateConfirmed(boolean b) {
        if (b) {
            this.confirmedThreads.put(Thread.currentThread(), this);
        } else {
            this.confirmedThreads.remove(Thread.currentThread());
        }
    }

    @Override
    public void updateGuiIcon(ImageIcon icon) {
        this.statusIcon = icon;
        this.eventSender.fireEvent(new UpdateStatusUpdateEvent(this, this.statusLabel, this.statusIcon, this.statusProgress));
    }

    @Override
    public void updateGuiText(String text) {
        if (!Application.isHeadless()) {
            this.lazyGetIcon().setTitle(text);
        }
        this.statusLabel = text;
        this.eventSender.fireEvent(new UpdateStatusUpdateEvent(this, this.statusLabel, this.statusIcon, this.statusProgress));
    }

    @Override
    public void updateGuiProgress(double progress) {
        this.statusProgress = progress;
        if (!Application.isHeadless()) {
            this.lazyGetIcon().setIndeterminate(progress < 0.0);
            this.lazyGetIcon().setValue((int)progress);
        }
        this.eventSender.fireEvent(new UpdateStatusUpdateEvent(this, this.statusLabel, this.statusIcon, this.statusProgress));
    }

    public String getAppID() {
        UpdateHandler lhandler = this.handler;
        if (lhandler == null) {
            return "NotConnected";
        }
        return lhandler.getAppID();
    }

    public void runUpdateChecker(boolean manually) {
        UpdateHandler lhandler = this.handler;
        if (lhandler == null) {
            return;
        }
        lhandler.runUpdateCheck(manually);
    }

    private int readRevision(String rev) {
        try {
            File revisionFile = Application.getResource(rev);
            if (revisionFile.exists()) {
                String string = IO.readFileToTrimmedString(revisionFile);
                if (string != null && string.matches("^\\d+$")) {
                    return Integer.parseInt(string);
                }
                Map ret = JSonStorage.restoreFromString(string, TypeRef.HASHMAP);
                if (ret != null && ret.containsKey("id")) {
                    return ((Number)ret.get("id")).intValue();
                }
            }
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        return -1;
    }

    @Override
    public void setRunning(boolean b) {
        this.running = b;
        if (!b) {
            this.installedRevisionJDU = this.readRevision("update/versioninfo/JDU/rev");
            this.installedRevisionJD = this.readRevision("update/versioninfo/JD/rev");
        }
        if (!Application.isHeadless()) {
            new EDTRunner(){

                @Override
                protected void runInEDT() {
                    if (UpdateController.this.running) {
                        if (UpdateController.this.icon != null && UpdateController.this.lazyGetIcon().getParent() != null) {
                            return;
                        }
                        UpdateController.this.lazyGetIcon().setIndeterminate(true);
                        UpdateController.this.lazyGetIcon().setTitle(_GUI.T.JDUpdater_JDUpdater_object_icon());
                        UpdateController.this.lazyGetIcon().setDescription(null);
                        JDGui.getInstance().getStatusBar().addProcessIndicator((JComponent)((Object)UpdateController.this.icon));
                    } else {
                        UpdateController.this.lazyGetIcon().setIndeterminate(false);
                        JDGui.getInstance().getStatusBar().removeProcessIndicator((JComponent)((Object)UpdateController.this.icon));
                    }
                }
            };
        }
    }

    protected IconedProcessIndicator lazyGetIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        this.icon = (UpdateProgress)((Object)new EDTHelper<UpdateProgress>(){

            @Override
            public UpdateProgress edtRun() {
                if (UpdateController.this.icon != null) {
                    return UpdateController.this.icon;
                }
                UpdateProgress icon = new UpdateProgress();
                ((ImagePainter)icon.getValueClipPainter()).setBackground(Color.LIGHT_GRAY);
                ((ImagePainter)icon.getValueClipPainter()).setForeground(Color.GREEN);
                icon.setTitle(_GUI.T.JDUpdater_JDUpdater_object_icon());
                icon.setEnabled(true);
                icon.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                    }
                });
                return icon;
            }
        }.getReturnValue());
        return this.icon;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public void setGuiVisible(boolean b) {
        UpdateHandler lhandler = this.handler;
        if (lhandler != null) {
            lhandler.setGuiVisible(b, true);
        }
    }

    @Override
    public boolean handleException(Exception e) {
        return false;
    }

    public void setGuiToFront(JFrame mainFrame) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                UpdateHandler lhandler = UpdateController.this.handler;
                if (lhandler != null && lhandler.isGuiVisible()) {
                    lhandler.setGuiVisible(true, true);
                }
            }
        };
    }

    @Override
    public void onGuiVisibilityChanged(Window window, boolean oldValue, boolean newValue) {
    }

    @Override
    public Locator getGuiLocator() {
        if (JDGui.getInstance().getMainFrame() != null) {
            return new RememberRelativeLocator("Updater", (Window)JDGui.getInstance().getMainFrame());
        }
        return null;
    }

    @Override
    public boolean doContinueLoopStarted() {
        return true;
    }

    @Override
    public boolean doContinueUpdateAvailable(boolean app, boolean updater, long appDownloadSize, long updaterDownloadSize, int appRevision, int updaterRevision, int appDestRevision, int updaterDestRevision) {
        if (!this.settings.isDoAskBeforeDownloadingAnUpdate()) {
            return true;
        }
        if (this.isThreadConfirmed()) {
            return true;
        }
        try {
            if (app && appDownloadSize < 0L || updater && updaterDownloadSize < 0L) {
                this.confirm(0, _UPDATE.T.confirmdialog_new_update_available_frametitle(), _UPDATE.T.confirmdialog_new_update_available_message(), _UPDATE.T.confirmdialog_new_update_available_answer_now(), _UPDATE.T.confirmdialog_new_update_available_answer_later());
            } else {
                long download = 0L;
                if (app) {
                    download += appDownloadSize;
                }
                if (updater) {
                    download += updaterDownloadSize;
                }
                this.confirm(0, _UPDATE.T.confirmdialog_new_update_available_frametitle(), _UPDATE.T.confirmdialog_new_update_available_message_sized(SizeFormatter.formatBytes(download)), _UPDATE.T.confirmdialog_new_update_available_answer_now(), _UPDATE.T.confirmdialog_new_update_available_answer_later());
            }
            return true;
        }
        catch (DialogClosedException e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        catch (DialogCanceledException e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        return false;
    }

    @Override
    public boolean doContinuePackageAvailable(boolean app, boolean updater, long appDownloadSize, long updaterDownloadSize, int appRevision, int updaterRevision, int appDestRevision, int updaterDestRevision) {
        return true;
    }

    @Override
    public boolean doContinueReadyForExtracting(boolean app, boolean updater, File fileclient, File fileself) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResults(boolean app, boolean updater, int clientRevision, int clientDestRevision, int selfRevision, int selfDestRevision, File awfFileclient, File awfFileSelf, File selfWOrkingDir, boolean jdlaunched) throws InterruptedException, IOException {
        block20: {
            try {
                this.logger.info("onResult");
                if (this.handler.hasPendingSelfupdate()) {
                    this.fireUpdatesAvailable(false, this.handler.createAWFInstallLog());
                    if (!this.isThreadConfirmed()) {
                        if (this.handler.isGuiVisible() || this.settings.isDoAskMeBeforeInstallingAnUpdateEnabled()) {
                            this.logger.info("ASK for installing selfupdate");
                            this.confirm(4, _UPDATE.T.confirmdialog_new_update_available_frametitle(), _UPDATE.T.confirmdialog_new_update_available_for_install_message(), _UPDATE.T.confirmdialog_new_update_available_answer_now_install(), _UPDATE.T.confirmdialog_new_update_available_answer_later_install());
                            this.setUpdateConfirmed(true);
                            this.handler.setGuiVisible(true, true);
                        } else {
                            return;
                        }
                    }
                    this.logger.info("Run Installing Updates");
                    UpdateController.getInstance().installUpdates(null);
                    return;
                }
                final InstallLog awfoverview = this.handler.createAWFInstallLog();
                this.logger.info(JSonStorage.toString(awfoverview));
                if (awfoverview.getSourcePackages().size() == 0) {
                    this.logger.info("Nothing to install " + this.handler.isGuiVisible());
                    this.handler.setGuiFinished(null);
                    if (this.settings.isAutohideGuiIfThereAreNoUpdatesEnabled()) {
                        this.handler.setGuiVisible(false, false);
                    }
                    this.fireUpdatesAvailable(false, null);
                    return;
                }
                if (awfoverview.getModifiedFiles().size() == 0) {
                    this.logger.info("Nothing to install2");
                    UpdateController.getInstance().installUpdates(awfoverview);
                    this.handler.setGuiFinished(null);
                    if (this.settings.isAutohideGuiIfThereAreNoUpdatesEnabled()) {
                        this.handler.setGuiVisible(false, false);
                    }
                    this.fireUpdatesAvailable(false, null);
                    return;
                }
                if (awfoverview.getModifiedRestartRequiredFiles().size() == 0) {
                    this.logger.info("Only directs");
                    if (!this.settings.isInstallUpdatesSilentlyIfPossibleEnabled()) {
                        this.logger.info("ask to install plugins");
                        this.confirm(4, _UPDATE.T.confirmdialog_new_update_available_frametitle(), _UPDATE.T.confirmdialog_new_update_available_for_install_message_plugin(), _UPDATE.T.confirmdialog_new_update_available_answer_now_install(), _UPDATE.T.confirmdialog_new_update_available_answer_later_install());
                    }
                    this.logger.info("run install");
                    UpdateController.getInstance().installUpdates(awfoverview);
                    if (awfoverview.getModifiedPlugins().size() > 0) {
                        this.logger.info("start scanner");
                        new Thread("PluginScanner"){

                            @Override
                            public void run() {
                                for (String plugin : awfoverview.getModifiedPlugins()) {
                                    if (StringUtils.containsIgnoreCase(plugin, "jd/plugins/hoster")) {
                                        HostPluginController.getInstance().invalidateCache();
                                    } else if (StringUtils.containsIgnoreCase(plugin, "jd/plugins/decrypter")) {
                                        CrawlerPluginController.invalidateCache();
                                    }
                                    HostPluginController.getInstance().ensureLoaded();
                                    CrawlerPluginController.getInstance().ensureLoaded();
                                }
                            }
                        }.start();
                    }
                    this.logger.info("set gui finished");
                    this.handler.setGuiFinished(_UPDATE.T.updatedplugins());
                    if (this.settings.isAutohideGuiIfSilentUpdatesWereInstalledEnabled()) {
                        this.handler.setGuiVisible(false, false);
                    }
                    this.fireUpdatesAvailable(false, null);
                    return;
                }
                this.fireUpdatesAvailable(false, awfoverview);
                if (this.isThreadConfirmed()) {
                    this.installUpdates(awfoverview);
                    this.fireUpdatesAvailable(false, null);
                    break block20;
                }
                if (this.handler.isGuiVisible() || this.settings.isDoAskMeBeforeInstallingAnUpdateEnabled()) {
                    List<String> rInstalls = this.handler.getRequestedInstalls();
                    List<String> ruInstalls = this.handler.getRequestedUnInstalls();
                    if (rInstalls.size() > 0 || ruInstalls.size() > 0) {
                        this.confirm(4, _UPDATE.T.confirmdialog_new_update_available_frametitle_extensions(), _UPDATE.T.confirmdialog_new_update_available_for_install_message_extensions(rInstalls.size(), ruInstalls.size()), _UPDATE.T.confirmdialog_new_update_available_answer_now_install(), _UPDATE.T.confirmdialog_new_update_available_answer_later_install());
                    } else {
                        this.confirm(4, _UPDATE.T.confirmdialog_new_update_available_frametitle(), _UPDATE.T.confirmdialog_new_update_available_for_install_message(), _UPDATE.T.confirmdialog_new_update_available_answer_now_install(), _UPDATE.T.confirmdialog_new_update_available_answer_later_install());
                    }
                    this.setUpdateConfirmed(true);
                    this.handler.setGuiVisible(true, true);
                    UpdateController.getInstance().installUpdates(awfoverview);
                    this.fireUpdatesAvailable(false, null);
                    break block20;
                }
                return;
            }
            catch (DialogNoAnswerException e) {
                this.logger.log(e);
                this.handler.setGuiVisible(false, false);
            }
        }
    }

    private void fireUpdatesAvailable(boolean self, InstallLog installLog) {
        this.hasPendingUpdates = this.handler.hasPendingUpdates();
        this.eventSender.fireEvent(new UpdaterEvent(this, UpdaterEvent.Type.UPDATES_AVAILABLE, self, installLog));
    }

    public UpdaterEventSender getEventSender() {
        return this.eventSender;
    }

    private void confirm(int flags, String title, String message, String ok, String no) throws DialogCanceledException, DialogClosedException {
        final UpdateHandler lhandler = this.handler;
        ConfirmUpdateDialog cd = new ConfirmUpdateDialog(flags, title, message, null, ok, no){

            @Override
            protected Window getDesiredRootFrame() {
                if (lhandler == null) {
                    return null;
                }
                return lhandler.getGuiFrame();
            }
        };
        ((ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, cd)).throwCloseExceptions();
        if (cd.isClosedBySkipUntilNextRestart()) {
            if (lhandler != null) {
                lhandler.stopIntervalChecker();
            }
            throw new DialogCanceledException(0);
        }
    }

    public boolean hasPendingUpdates() {
        return this.hasPendingUpdates;
    }

    public void installUpdates(InstallLog log) {
        this.handler.installPendingUpdates(log);
        this.handler.clearInstallLogs();
    }

    @Override
    public Process runExeAsynch(List<String> call, File root) throws IOException {
        if (DEBUG_SELFTEST_PORT > 0) {
            call.addAll(RestartController.getInstance().getFilteredRestartParameters(new String[0]));
            call.add(1, "-Xdebug");
            call.add(2, "-Xrunjdwp:transport=dt_socket,server=y,address=" + DEBUG_SELFTEST_PORT + ",suspend=y");
            this.logger.info("Call: " + call + " in " + root);
            if (CrossSystem.isWindows()) {
                StringBuilder sb = new StringBuilder();
                sb.append("@echo SelfTest for Windows").append("\r\n");
                long time = System.currentTimeMillis();
                sb.append("@echo The Selftest will start now and write all outputs in this window and to " + new File(root, "self_log_err/std" + time + ".txt")).append("\r\n");
                for (String c : call) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append("\"").append(c).append("\"");
                }
                File tmp = Application.getTempResource("selftestLaunch.bat");
                tmp.delete();
                sb.append(" >self_log_std" + time + ".txt  2>self_log_err" + time + ".txt\r\ntype self_log_std" + time + ".txt\r\ntype self_log_err" + time + ".txt");
                sb.append("\r\n");
                sb.append("@echo Please close this window now.");
                IO.writeStringToFile(tmp, sb.toString());
                ArrayList<String> newList = new ArrayList<String>();
                newList.add("cmd");
                newList.add("/C");
                newList.add("start");
                newList.add("/wait");
                newList.add(tmp.getAbsolutePath());
                call = newList;
            }
            ProcessBuilder pb = ProcessBuilderFactory.create(call);
            pb.redirectErrorStream(true);
            pb.directory(root);
            Process process = pb.start();
            if (process != null) {
                this.logger.logAsynch(process.getInputStream());
            }
            return process;
        }
        call.addAll(RestartController.getInstance().getFilteredRestartParameters(new String[0]));
        this.logger.info("Start Process: " + call);
        ProcessBuilder pb = ProcessBuilderFactory.create(call);
        pb.directory(root);
        Process process = pb.start();
        this.logger.logAsynch(process.getErrorStream());
        this.logger.logAsynch(process.getInputStream());
        return process;
    }

    public boolean isExtensionInstalled(String id) {
        return this.handler != null && this.handler.isExtensionInstalled(id);
    }

    public boolean isHandlerSet() {
        return this.handler != null;
    }

    public void runExtensionUnInstallation(String id) throws InterruptedException {
        this.handler.uninstallExtension(id);
    }

    public void runExtensionInstallation(String id) throws InterruptedException {
        this.handler.installExtension(id);
    }

    public void waitForUpdate() throws InterruptedException {
        this.handler.waitForUpdate();
    }

    @Override
    public HTTPProxy updateProxyAuth(int retries, HTTPProxy usedProxy, List<String> proxyAuths, URL url) {
        return ProxyController.getInstance().updateProxyAuthForUpdater(retries, usedProxy, proxyAuths, url);
    }

    @Override
    public List<HTTPProxy> selectProxy(URL url) {
        ArrayList<HTTPProxy> ret = new ArrayList<HTTPProxy>();
        List lst = ProxyController.getInstance().getProxiesForUpdater(url);
        for (HTTPProxy p : lst) {
            ret.add(new ProxyClone(p));
        }
        return ret;
    }

    public void runExtensionsFullUpdate(ArrayList<String> list) {
        if (this.handler == null || !Application.isJared(null)) {
            return;
        }
        this.handler.requestFullExtensionUpdate(list.toArray(new String[0]));
        this.runUpdateChecker(false);
    }

    @Override
    public void append(StringBuilder sb) {
        if (sb != null && !new Regex((CharSequence)sb, ".*app=JDU.*").matches()) {
            boolean hwDebug = false;
            if (Boolean.FALSE.equals(this.getExtractionLibrary())) {
                try {
                    HardwareTypeInterface hardware;
                    sb.append("&7zjb=false");
                    String errorDetails = this.getExtractionError();
                    if (errorDetails != null) {
                        sb.append("&7zjberror=" + URLEncode.encodeURIComponent(errorDetails));
                    }
                    if ((hardware = HardwareType.getHardware()) != null) {
                        sb.append("&hw=" + URLEncode.encodeURIComponent(hardware.toString()));
                        hwDebug = true;
                    }
                }
                catch (Throwable e) {
                    this.logger.log(e);
                }
            }
            if (!hwDebug) {
                try {
                    HardwareTypeInterface hardware = HardwareType.getHardware();
                    if (hardware != null) {
                        sb.append("&hw=" + (Object)((Object)hardware.getHardwareType()));
                    }
                }
                catch (Throwable e) {
                    this.logger.log(e);
                    sb.append("&hw=error");
                }
            }
        }
    }
}

