/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.updatev2.gui;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JsonKeyValueStorage;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.StorageHandlerFactory;
import org.appwork.storage.config.handler.DefaultFactoryInterface;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.swing.synthetica.SyntheticaHelper;
import org.appwork.swing.synthetica.SyntheticaSettings;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.dialog.Dialog;
import org.jdownloader.updatev2.gui.LAFOptions;
import org.jdownloader.updatev2.gui.LAFSettings;

public class LAFSettingsStorageHandlerFactory
implements StorageHandlerFactory<LAFSettings> {
    private static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static void main(String[] args) throws IOException {
        Application.setApplication(".jd_home");
        SyntheticaHelper.init();
    }

    @Override
    public StorageHandler<LAFSettings> create(File path, Class<LAFSettings> configInterface) {
        StorageHandler<LAFSettings> ret = new StorageHandler<LAFSettings>(path, configInterface){

            @Override
            protected void error(final Throwable e) {
                if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
                    new Thread("ERROR THROWER"){

                        @Override
                        public void run() {
                            Dialog.getInstance().showExceptionDialog(e.getClass().getSimpleName(), e.getMessage(), e);
                        }
                    }.start();
                }
            }

            @Override
            protected void preInit(File path, Class<LAFSettings> configInterfac) {
                this.setDefaultFactory(new DefaultFactoryInterface(){

                    @Override
                    public Object getDefaultValue(KeyHandler<?> handler, Object o) {
                        Object def = o;
                        try {
                            def = handler.getGetMethod().invoke((Object)LAFOptions.getLookAndFeelExtension(), new Object[0]);
                        }
                        catch (Throwable e) {
                            LoggerFactory.getDefaultLogger().log(e);
                        }
                        return def;
                    }
                });
            }
        };
        for (KeyHandler<?> keyHandler : ret.getKeyHandler()) {
            keyHandler.setAllowWriteDefaultObjects(false);
        }
        try {
            File oldLafSettingsFile = Application.getResource("cfg/org.appwork.swing.synthetica.SyntheticaSettings.json");
            if (oldLafSettingsFile.exists()) {
                JsonKeyValueStorage prim = (JsonKeyValueStorage)JsonConfig.create(SyntheticaSettings.class)._getStorageHandler().getPrimitiveStorage();
                for (String s : prim.getKeys()) {
                    try {
                        KeyHandler<Object> keyH = ret.getKeyHandler(s.toLowerCase(Locale.ENGLISH));
                        Object oldValue = prim.get(s, null);
                        if (keyH == null || LAFSettingsStorageHandlerFactory.equals(oldValue, keyH.getDefaultValue())) continue;
                        keyH.setValueAutoConvert(oldValue);
                    }
                    catch (Throwable e) {
                        LoggerFactory.getDefaultLogger().log(e);
                    }
                }
                JsonConfig.create(SyntheticaSettings.class)._getStorageHandler().setSaveInShutdownHookEnabled(false);
                oldLafSettingsFile.delete();
            }
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        return ret;
    }

    @Override
    public StorageHandler<LAFSettings> create(String urlPath, Class<LAFSettings> configInterface) {
        throw new WTFException("Not Implemented");
    }
}

